package examples.messaging;

import javax.jms.*;
import javax.ejb.*;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;

@MessageDriven(activationConfig = 
{ @ActivationConfigProperty(propertyName = "destinationType", 
        propertyValue = "javax.jms.Topic") })
public class PoisonBean implements MessageListener {

    @Resource
    private MessageDrivenContext ctx;

    public PoisonBean() {
        System.out.println("PoisonBean created");
    }

    public void onMessage(Message msg) {
        try {
            System.out.println("Received msg " + msg.getJMSMessageID());

            // Lets sleep a little bit so that we dont
            // see rapid fire re-sends of the message.
            Thread.sleep(3000);

            // We could either throw a system exception here or
            // manually force a rollback of the transaction.
            ctx.setRollbackOnly();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void remove() {
        System.out.println("PoisonBean destroyed.");
    }
}